#include "ydb_requests.h"

#include <crypta/lib/native/ydb/executer.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

NYdb::NTable::TAsyncDataQueryResult NSiberia::SaveStats(TYdbClient& ydbClient, TUserSetId userSetId, ui64 processedUsersCount, NLab::TUserDataStats userDataStats, bool ready) {
    return ExecuteYdbQuery<TSaveStatsDbRequest>(ydbClient, "", {.UserSetId = userSetId, .ProcessedUsersCount = processedUsersCount, .UserDataStats = userDataStats, .Ready = ready});
}

NYdb::NTable::TDataQueryResult NSiberia::SaveStats(NYdb::NTable::TSession& session, const TString& path, TUserSetId userSetId, ui64 processedUsersCount, NLab::TUserDataStats userDataStats, bool ready, NYdb::NTable::TTxControl&& txControl) {
    return ExecuteYdbQueryInSession<TSaveStatsDbRequest>(session, path, {.UserSetId = userSetId, .ProcessedUsersCount = processedUsersCount, .UserDataStats = userDataStats, .Ready = ready}, std::move(txControl));
}

NYdb::NTable::TAsyncDataQueryResult NSiberia::GetUserSetStats(TYdbClient& ydbClient, TUserSetId userSetId) {
    return ExecuteYdbQuery<TGetStatsDbRequest>(ydbClient, "", {.UserSetId = userSetId}, NYdb::NTable::TTxSettings::StaleRO());
}

NYdb::NTable::TDataQueryResult NSiberia::GetUserSetStats(NYdb::NTable::TSession& session, const TString& path, TUserSetId userSetId, NYdb::NTable::TTxControl&& txControl) {
    return ExecuteYdbQueryInSession<TGetStatsDbRequest>(session, path, {.UserSetId = userSetId}, std::move(txControl));
}
