#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/siberia/bin/common/data/types.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/generic/string.h>

namespace NCrypta::NSiberia {
    struct TSaveStatsDbRequest {
        struct TRequestParams {
            const TUserSetId UserSetId = 0;
            ui64 ProcessedUsersCount = 0;
            const NLab::TUserDataStats& UserDataStats;
            bool Ready = false;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            PRAGMA SimpleColumns = '1';

            DECLARE $userSetId as UInt64;
            DECLARE $processed_users_count as UInt64;
            DECLARE $stats as String;
            DECLARE $ready as Bool;

            UPSERT INTO user_set_stats (user_set_id, processed_users_count, stats, ready)
            VALUES ($userSetId, $processed_users_count, $stats, $ready)
        )";

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            TString userDataStatsStr;
            Y_PROTOBUF_SUPPRESS_NODISCARD params.UserDataStats.SerializeToString(&userDataStatsStr);
            return paramsBuilder.AddParam("$userSetId").Uint64(params.UserSetId).Build()
                .AddParam("$processed_users_count").Uint64(params.ProcessedUsersCount).Build()
                .AddParam("$stats").String(userDataStatsStr).Build()
                .AddParam("$ready").Bool(params.Ready).Build()
                .Build();
        }
    };

    struct TGetStatsDbRequest {
        struct TRequestParams {
            TUserSetId UserSetId = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            DECLARE $userSetId as Uint64;

            SELECT
                *
            FROM user_set_stats
            WHERE user_set_id == $userSetId
        )";

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$userSetId").Uint64(params.UserSetId).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult GetUserSetStats(TYdbClient& ydbClient, TUserSetId userSetId);
    NYdb::NTable::TDataQueryResult GetUserSetStats(NYdb::NTable::TSession& session, const TString& path, TUserSetId userSetId, NYdb::NTable::TTxControl&& txControl);

    NYdb::NTable::TAsyncDataQueryResult SaveStats(TYdbClient& ydbClient, TUserSetId userSetId, ui64 processedUsersCount, NLab::TUserDataStats userDataStats, bool ready);
    NYdb::NTable::TDataQueryResult SaveStats(NYdb::NTable::TSession& session, const TString& path, TUserSetId userSetId, ui64 processedUsersCount, NLab::TUserDataStats userDataStats, bool ready, NYdb::NTable::TTxControl&& txControl);
}
