#include "processor.h"

#include <crypta/lib/native/ydb/ydb_error_exception.h>

using namespace NCrypta::NSiberia;

TProcessor::TProcessor(TYdbClient& ydbClient, TStats& stats)
    : YdbClient(ydbClient)
    , Stats(stats)
    , Log(NLog::GetLog("worker"))
{}

bool TProcessor::Process() {
    try {
        return ProcessUnsafe();
    } catch (const TYdbErrorException& e) {
        Stats.Count->Add("errors.ydb");
        Log->error("YDB Exception. Status: {}; Message: {};", e.GetStatus().GetIssues().ToString(), e.what());
        return false;
    } catch (const std::exception& e) {
        Stats.Count->Add("errors.unknown");
        Log->error("Exception: {};", e.what());
        return true;
    } catch (...) {
        Stats.Count->Add("errors.unknown");
        Log->error("Unknown exception");
        return true;
    }
}
