#pragma once

#include <crypta/lib/native/event_processing/processor.h>
#include <crypta/lib/native/log/log.h>
#include <crypta/lib/native/stats/stats.h>
#include <crypta/lib/native/ydb/ydb_client.h>

namespace NCrypta::NSiberia {
    class TProcessor : public NEventProcessing::IProcessor {
    public:
        TProcessor(TYdbClient& ydbClient, TStats& stats);

        bool Process() override;

    protected:
        virtual bool ProcessUnsafe() = 0;

        TYdbClient& YdbClient;
        TStats& Stats;
        NLog::TLogPtr Log;
    };
}
