from google.protobuf import json_format

from crypta.siberia.bin.common.mutations.proto import (
    mutation_pb2,
    remove_segment_data_command_pb2,
    remove_user_set_data_command_pb2,
)


def create_remove_user_set_data_command(user_set_id):
    return mutation_pb2.TMutation(RemoveUserSetDataCommand=remove_user_set_data_command_pb2.TRemoveUserSetDataCommand(
        UserSetId=user_set_id,
    ))


def create_remove_segment_data_command(user_set_id, segment_id):
    return mutation_pb2.TMutation(RemoveSegmentDataCommand=remove_segment_data_command_pb2.TRemoveSegmentDataCommand(
        UserSetId=user_set_id,
        SegmentId=segment_id,
    ))


def from_json(text):
    return json_format.Parse(text, mutation_pb2.TMutation())
