from google.protobuf import json_format

from crypta.siberia.bin.common.segmentation.proto import (
    message_pb2,
    segmentate_command_pb2,
)


def create_segmentate_command(user_set_id, segment_id):
    return message_pb2.TMessage(SegmentateCommand=segmentate_command_pb2.TSegmentateCommand(
        UserSetId=user_set_id,
        SegmentId=segment_id,
    ))


def from_json(text):
    return json_format.Parse(text, message_pb2.TMessage())
