#include "helpers.h"
#include "rule_lexer.h"
#include "rule_parser.h"

using namespace NCrypta::NSiberia;

NRuleParser::TResult NRuleParser::Parse(const TString& rule) {
    TRuleLexer lexer(rule);
    TExpressionPtr expression;
    TString errorMessage;
    TRuleParser parser(lexer, expression, errorMessage);
    return {
        .Expression = parser.parse() == 0 ? MakeMaybe(expression) : Nothing(),
        .ErrorMessage = errorMessage
    };
}
