#pragma once

#include "rule_ast.h"

namespace NCrypta::NSiberia {
    class TRuleApplier {
    public:
        TRuleApplier(const TExpressionPtr& expression);

        bool IsSatisfy(const NYT::TNode::TMapType& node) const;

    private:
        TExpressionPtr Expression = nullptr;
    };

    bool ApplyRule(const TExpressionPtr& expression, const NYT::TNode::TMapType& node);

    class TApplyVisitor : public IVisitor {
    public:
        using TSelf = TApplyVisitor;

        TApplyVisitor(const NYT::TNode::TMapType& node);

        void visitSimpleExpression(const TSimpleExpression& expression) override final;
        void visitUnaryExpression(const TUnaryExpression& expression) override final;
        void visitBinaryExpression(const TBinaryExpression& expression) override final;

        const NYT::TNode::TMapType& Node;
        bool Result = false;
    };
}
