#include "rule_ast.h"

using namespace NCrypta::NSiberia;

TSimpleExpression::TSimpleExpression(EOp op, const TFieldType& field, const TValueType& value)
    : Op(op)
    , Field(field)
    , Value(value)
{}

TSimpleExpression::~TSimpleExpression() {}

void TSimpleExpression::accept(IVisitor& visitor) const {
    visitor.visitSimpleExpression(*this);
}

TUnaryExpression::TUnaryExpression(EOp op, const TExpressionPtr& child)
    : Op(op)
    , Child(child)
{
    Y_ENSURE(Child != nullptr);
}

TUnaryExpression::~TUnaryExpression() {}

void TUnaryExpression::accept(IVisitor& visitor) const {
    visitor.visitUnaryExpression(*this);
}

TBinaryExpression::TBinaryExpression(EOp op, const TExpressionPtr& left, const TExpressionPtr& right)
    : Op(op)
    , Left(left)
    , Right(right)
{
    Y_ENSURE(Left != nullptr);
    Y_ENSURE(Right != nullptr);
}

TBinaryExpression::~TBinaryExpression() {}

void TBinaryExpression::accept(IVisitor& visitor) const {
    visitor.visitBinaryExpression(*this);
}

TExpressionPtr NCrypta::NSiberia::MakeSimpleExpression(TSimpleExpression::EOp op, const TSimpleExpression::TFieldType& field, const TSimpleExpression::TValueType& value) {
    return MakeAtomicShared<TSimpleExpression>(op, field, value);
}

TExpressionPtr NCrypta::NSiberia::MakeUnaryExpression(TUnaryExpression::EOp op, const TExpressionPtr& child) {
    return MakeAtomicShared<TUnaryExpression>(op, child);
}

TExpressionPtr NCrypta::NSiberia::MakeBinaryExpression(TBinaryExpression::EOp op, const TExpressionPtr& left, const TExpressionPtr& right) {
    return MakeAtomicShared<TBinaryExpression>(op, left, right);
}
