#include "rule_ast_serialization.h"

#include <library/cpp/yson/node/node_io.h>

#include <util/string/builder.h>

using namespace NCrypta::NSiberia;

TString NCrypta::NSiberia::Serialize(const TExpressionPtr& expression) {
    TRuleAstSerializationVisitor visitor;
    expression->accept(visitor);
    return visitor.Result;
}

void TRuleAstSerializationVisitor::visitSimpleExpression(const TSimpleExpression& expression) {
    Result = (TStringBuilder() << "(" << expression.Field << " " << expression.Op << " " << NYT::NodeToCanonicalYsonString(expression.Value) << ")");
}

void TRuleAstSerializationVisitor::visitUnaryExpression(const TUnaryExpression& expression) {
    Result = (TStringBuilder() << "(" << expression.Op << " " << Serialize(expression.Child) << ")");
}

void TRuleAstSerializationVisitor::visitBinaryExpression(const TBinaryExpression& expression) {
    Result = (TStringBuilder() << "(" << Serialize(expression.Left) << " " << expression.Op << " " << Serialize(expression.Right) << ")");
}
