#pragma once

#include "rule_parser.h"

#include <util/generic/string.h>

namespace NCrypta::NSiberia {
    class TRuleLexer {
    public:
        TRuleLexer(const TString& text);

        TRuleParser::token_type GetNextToken(TRuleParser::semantic_type*, TRuleParser::location_type* location);

    private:
        TString Text;

        /* Variables Used by Ragel */
        int cs;     // Current state
        char* p;    // Data pointer
        char* pe;   // Data end pointer
        char* eof;  // End of file pointer
        int act;    // Used by scanner
        char* ts;   // Used by scanner
        char* te;   // Used by scanner
    };
}
