#pragma once

#include <crypta/lib/native/tvm/proto/tvm_config.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/lib/proto/identifiers/id.pb.h>
#include <crypta/siberia/bin/common/describing/experiment/proto/describing_experiment.pb.h>
#include <crypta/siberia/bin/common/proto/stats.pb.h>

#include <library/cpp/cgiparam/cgiparam.h>
#include <library/cpp/neh/http_common.h>
#include <library/cpp/retry/retry.h>
#include <library/cpp/tvmauth/client/facade.h>

#include <util/generic/maybe.h>
#include <util/generic/string.h>

namespace NCrypta::NSiberia {
    class TSiberiaClientException : public yexception {
    };

    class TSiberiaClient {
    public:
        TSiberiaClient(const TString& host, ui32 port, TDuration timeout, const NTvmAuth::TTvmClient& tvmClient, TRetryOptions retryOptions);

        TUserSetId DescribeIds(const TIds& ids, const TMaybe<TString> mode = Nothing(), const TMaybe<TDescribingExperiment> experiment = Nothing()) const;
        TStats GetUserSetStats(TUserSetId userSetId) const;

        static constexpr const char* SIBERIA_TVM_ALIAS = "siberia";
        static constexpr const char* DESCRIBING_MODE_CGI_PARAM = "mode";
        static constexpr const char* EXPERIMENT_CGI_PARAM = "experiment";

    private:
        NNeh::TMessage BuildMessage(const TString& url, const TStringBuf& content, const TStringBuf& contentType = NNeh::NHttp::DefaultContentType) const;
        NNeh::TResponseRef SendMessageWithRetries(const NNeh::TMessage& message) const;
        TString GetUrl(const TString& scheme, const TString& path, const TCgiParameters& cgiParameters) const;

        const TString Address;
        const NTvmAuth::TTvmClient& TvmClient;
        const TRetryOptions RetryOptions;
        const TDuration Timeout;
    };
}
