#pragma once

#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/proto/user.pb.h>
#include <crypta/siberia/bin/common/data/proto/user_set.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/describing/data/user_set_stats.h>
#include <crypta/siberia/bin/common/proto/stats.pb.h>

#include <ydb/public/sdk/cpp/client/ydb_table/table.h>

#include <util/generic/maybe.h>
#include <util/generic/vector.h>

namespace NCrypta::NSiberia::NYdbCommonParseUtils {
    void ParseUserDataStats(NLab::TUserDataStats& userDataStats, NYdb::TResultSetParser& parser, const TString& columnName);
    NLab::TUserDataStats ParseUserDataStats(NYdb::TResultSetParser& parser, const TString& columnName);
    TVector<NLab::TUserDataStats> ParseUserDataStats(const NYdb::TResultSet& resultSet);

    TMaybe<NLab::TUserDataStats> ParseSingleUserDataStats(const NYdb::TResultSet& resultSet);

    TMaybe<TUserSetStats> ParseUserSetStats(const NYdb::TResultSet& resultSet);

    TUserSet ParseUserSet(NYdb::TResultSetParser& parser);
    TMaybe<TUserSet> ParseUserSet(const NYdb::TResultSet& resultSet);

    TSegment ParseSegment(NYdb::TResultSetParser& parser);

    class TUserAttributesResultSetParser {
    public:
        struct TRow {
            TUserId UserId = 0;
            TString Key;
            TString Value;
        };

        TUserAttributesResultSetParser(const NYdb::TResultSet& resultSet);

        bool TryNextRow();

        TRow GetRow();

    private:
        NYdb::TResultSetParser ResultSetParser;
    };
}
