#include "add_users_to_segment_db_request.h"

#include "check_segment_and_users_db_request.h"

#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <util/string/vector.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

TDataQueryResult NSiberia::ExecuteAddUsersToSegmentDbRequest(NYdb::NTable::TSession& session, const TString& path, TSegmentId segmentId, const TVector<TUserId>& userIds, ui64 ts, TTxControl&& txControl) {
    return ExecuteYdbDynamicQueryInSession<TAddUsersToSegmentDbRequest>(session, path, {.UserIds = userIds, .SegmentId = segmentId, .Ts = ts}, std::move(txControl));
}

void NSiberia::AddUsersToSegment(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId, const TVector<TUserId>& userIds) {
    const auto& userSetDir = ydbClient.GetAbsolutePath(GetUserSetDirPath(userSetId));
    const auto result = ExecuteQueryWithRetries(ydbClient.TableClient, [userSetDir, segmentId, userIds](TSession session, NYT::TPromise<TDataQueryResult> resultPromise) {
        const auto checkResult = ExecuteCheckSegmentAndUsersDbRequest(session, userSetDir, segmentId, userIds, TTxControl::BeginTx(TTxSettings::SerializableRW()));

        if (!checkResult.IsSuccess()) {
            return checkResult;
        }

        const auto& [segmentExists, unknownUserIds] = ParseCheckSegmentAndUsersResult(checkResult);
        if (!segmentExists) {
            resultPromise.Set(NYT::TError("Unknown segment id"));
            return checkResult;
        }

        if (!unknownUserIds.empty()) {
            resultPromise.Set(NYT::TError("Unknown user ids: %s", JoinVectorIntoString(unknownUserIds, ",")));
            return checkResult;
        }

        auto addTxControl = TTxControl::Tx(*checkResult.GetTransaction()).CommitTx();
        const auto result = ExecuteAddUsersToSegmentDbRequest(session, userSetDir, segmentId, userIds, 1000000, std::move(addTxControl));

        if (result.IsSuccess()) {
            resultPromise.Set(result);
        }

        return result;
    });
    ThrowOnError(result);
}
