#include "check_segment_and_users_db_request.h"

#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/parse_utils.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

NYdb::NTable::TDataQueryResult NSiberia::ExecuteCheckSegmentAndUsersDbRequest(NYdb::NTable::TSession& session, const TString& path, TSegmentId segmentId, const TVector<TUserId>& userIds, NYdb::NTable::TTxControl&& txControl) {
    return ExecuteYdbDynamicQueryInSession<TCheckSegmentAndUsersDbRequest>(session, path, {.UserIds = userIds, .SegmentId = segmentId}, std::move(txControl));
}

std::pair<bool, TVector<TUserId>> NSiberia::ParseCheckSegmentAndUsersResult(const NYdb::NTable::TDataQueryResult& result) {
    const auto& segmentExists = NCrypta::NYdbParseUtils::ParseBool(result.GetResultSet(0), "segment_exists");

    TVector<TUserId> unknownUserIds;
    NYdb::TResultSetParser usersExistParser(result.GetResultSet(1));
    while (usersExistParser.TryNextRow()) {
        unknownUserIds.push_back(usersExistParser.ColumnParser("id").GetUint64());
    }

    return {segmentExists, std::move(unknownUserIds)};
}
