#pragma once

#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/proto/user.pb.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TCheckSegmentAndUsersDbRequest {
        struct TRequestParams {
            const TVector<TUserId>& UserIds;
            TSegmentId SegmentId = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $segmentId AS UInt64;
            DECLARE $userIds AS 'List<Struct<
                id: Uint64>>';

            SELECT
                COUNT(*) > 0 AS segment_exists
            FROM {segments_table}
            WHERE id == $segmentId;

            SELECT
                user_ids.id AS id
            FROM AS_TABLE($userIds) AS user_ids
            LEFT ONLY JOIN {users_table} AS users
            ON user_ids.id == users.id;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            SubstGlobal(query, "{users_table}", YDB_PATHS.GetUsersTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            paramsBuilder.AddParam("$segmentId").Uint64(params.SegmentId).Build();

            auto& userIdsParam = paramsBuilder.AddParam("$userIds");

            userIdsParam.BeginList();

            for (auto& userId : params.UserIds) {
                userIdsParam.AddListItem()
                    .BeginStruct()
                    .AddMember("id").Uint64(userId)
                    .EndStruct();
            }

            userIdsParam.EndList().Build();

            return paramsBuilder.Build();
        }
    };

    NYdb::NTable::TDataQueryResult ExecuteCheckSegmentAndUsersDbRequest(NYdb::NTable::TSession& session, const TString& path, TSegmentId segmentId, const TVector<TUserId>& userIds, NYdb::NTable::TTxControl&& txControl);

    std::pair<bool, TVector<TUserId>> ParseCheckSegmentAndUsersResult(const NYdb::NTable::TDataQueryResult& result);
}
