#include "get_segment_db_request.h"

#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>
#include <crypta/siberia/bin/common/ydb/parse_utils/parse_utils.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteGetSegmentDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId) {
    return ExecuteYdbDynamicQuery<TGetSegmentDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.SegmentId = segmentId});
}

TMaybe<TSegment> NSiberia::GetSegment(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId) {
    const auto result = WaitFor(ExecuteGetSegmentDbRequest(ydbClient, userSetId, segmentId)).ValueOrThrow();
    ThrowOnError(result);
    return ParseGetSegmentResult(result.GetResultSet(0));
}

TMaybe<TSegment> NSiberia::ParseGetSegmentResult(const NYdb::TResultSet& resultSet) {
    NYdb::TResultSetParser parser(resultSet);

    if (!parser.TryNextRow()) {
        return Nothing();
    }

    const auto& segment = NYdbCommonParseUtils::ParseSegment(parser);

    Y_ENSURE(!parser.TryNextRow(), "Too many results");

    return segment;
}
