#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/generic/maybe.h>
#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TGetSegmentDbRequest {
        struct TRequestParams {
            TSegmentId SegmentId = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $segmentId AS Uint64;

            SELECT
                *
            FROM {segments_table}
            WHERE id == $segmentId;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$segmentId").Uint64(params.SegmentId).Build()
                .Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteGetSegmentDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId);
    TMaybe<TSegment> GetSegment(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId);

    TMaybe<TSegment> ParseGetSegmentResult(const NYdb::TResultSet& resultSet);
}
