#include "get_user_set_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/lib/native/ydb/parse_utils.h>
#include <crypta/siberia/bin/common/ydb/parse_utils/parse_utils.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteGetUserSetDbRequest(TYdbClient& ydbClient, TUserSetId userSetId) {
    return ExecuteYdbDynamicQuery<TGetUserSetDbRequest>(ydbClient, "", {.UserSetId = userSetId});
}

TMaybe<TUserSet> NSiberia::GetUserSet(TYdbClient& ydbClient, TUserSetId userSetId) {
    const auto result = WaitFor(ExecuteGetUserSetDbRequest(ydbClient, userSetId)).ValueOrThrow();
    ThrowOnError(result);
    return NYdbCommonParseUtils::ParseUserSet(result.GetResultSet(0));
}
