#pragma once

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/user_set.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/generic/maybe.h>
#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TGetUserSetDbRequest {
        struct TRequestParams {
            TUserSetId UserSetId = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            PRAGMA SimpleColumns;
            DECLARE $userSetId AS UInt64;

            SELECT
                *
            FROM {user_sets_table}
            WHERE id == $userSetId;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{user_sets_table}", YDB_PATHS.GetUserSetsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            paramsBuilder.AddParam("$userSetId").Uint64(params.UserSetId).Build();
            return paramsBuilder.Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteGetUserSetDbRequest(TYdbClient& ydbClient, TUserSetId userSetId);
    TMaybe<TUserSet> GetUserSet(TYdbClient& ydbClient, TUserSetId userSetId);
}
