#include "remove_users_from_segments.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/lib/native/ydb/parse_utils.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteRemoveUsersFromSegmentsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TSegmentId>& segmentIds, ui64 limit) {
    return ExecuteYdbDynamicQuery<TRemoveUsersFromSegmentsDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.SegmentIds = segmentIds, .Limit = limit});
}

ui64 NSiberia::RemoveUsersFromSegments(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TSegmentId>& segmentIds, ui64 limit) {
    const auto result = WaitFor(ExecuteRemoveUsersFromSegmentsDbRequest(ydbClient, userSetId, segmentIds, limit)).ValueOrThrow();
    ThrowOnError(result);
    return NYdbParseUtils::ParseUint64(result.GetResultSet(0), "count");
}
