#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TRemoveUsersFromSegmentsDbRequest {
        struct TRequestParams {
            const TVector<TSegmentId>& SegmentIds;
            ui64 Limit = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");

            DECLARE $segmentIds AS 'List<Struct<id: Uint64>>';
            DECLARE $limit AS UInt64;

            $to_delete = (
                SELECT
                    segment_users.user_id AS user_id,
                    segment_ids.id AS segment_id
                FROM AS_TABLE($segmentIds) AS segment_ids
                JOIN {segment_users_table} AS segment_users
                ON segment_ids.id == segment_users.segment_id
                LIMIT $limit
            );

            DELETE FROM {user_segments_table} ON
            SELECT * FROM $to_delete;

            DELETE FROM {segment_users_table} ON
            SELECT * FROM $to_delete;

            SELECT
                COUNT(*) AS count
            FROM $to_delete;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segment_users_table}", YDB_PATHS.GetSegmentUsersTable());
            SubstGlobal(query, "{user_segments_table}", YDB_PATHS.GetUserSegmentsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            auto& segmentIdsParam = paramsBuilder.AddParam("$segmentIds");
            segmentIdsParam.BeginList();

            for (auto& id : params.SegmentIds) {
                segmentIdsParam.AddListItem()
                    .BeginStruct()
                    .AddMember("id").Uint64(id)
                    .EndStruct();
            }

            segmentIdsParam.EndList().Build();

            paramsBuilder.AddParam("$limit").Uint64(params.Limit).Build();

            return paramsBuilder.Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteRemoveUsersFromSegmentsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TSegmentId>& segmentIds, ui64 limit);
    ui64 RemoveUsersFromSegments(TYdbClient& ydbClient, TUserSetId userSetId, const TVector<TSegmentId>& segmentIds, ui64 limit);
}
