#include "segment_exists_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/lib/native/ydb/parse_utils.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;

NYdb::NTable::TDataQueryResult NSiberia::ExecuteSegmentExistsDbRequest(NYdb::NTable::TSession& session, const TString& path, TSegmentId segmentId, NYdb::NTable::TTxControl&& txControl) {
    return ExecuteYdbDynamicQueryInSession<TSegmentExistsDbRequest>(session, path, {.SegmentId = segmentId}, std::move(txControl));
}

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteSegmentExistsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId) {
    return ExecuteYdbDynamicQuery<TSegmentExistsDbRequest>(ydbClient, GetUserSetDirPath(userSetId), {.SegmentId = segmentId});
}

bool NSiberia::IsSegmentExists(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId) {
    const auto result = WaitFor(ExecuteSegmentExistsDbRequest(ydbClient, userSetId, segmentId)).ValueOrThrow();
    ThrowOnError(result);
    return NYdbParseUtils::ParseBool(result.GetResultSet(0), "result");
}
