#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/proto/segment.pb.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TSegmentExistsDbRequest {
        struct TRequestParams {
            TSegmentId SegmentId = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            DECLARE $segmentId AS UInt64;

            SELECT
                COUNT(*) != 0 AS result
            FROM {segments_table}
            WHERE id == $segmentId;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            paramsBuilder.AddParam("$segmentId").Uint64(params.SegmentId).Build();
            return paramsBuilder.Build();
        }
    };

    NYdb::NTable::TDataQueryResult ExecuteSegmentExistsDbRequest(NYdb::NTable::TSession& session, const TString& path, TSegmentId segmentId, NYdb::NTable::TTxControl&& txControl);
    NYdb::NTable::TAsyncDataQueryResult ExecuteSegmentExistsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId);

    bool IsSegmentExists(TYdbClient& ydbClient, TUserSetId userSetId, TSegmentId segmentId);
}
