#include "update_segment_db_request.h"

#include "segment_exists_db_request.h"

#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/lib/native/ydb/parse_utils.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

using namespace NCrypta;
using namespace NYdb::NTable;

TDataQueryResult NSiberia::ExecuteUpdateSegmentDbRequest(TSession& session, const TString& path, const TSegmentUpdateInfo& segmentUpdateInfo, TTxControl&& txControl) {
    return ExecuteYdbDynamicQueryInSession<TUpdateSegmentDbRequest>(session, path, {.SegmentInfo = segmentUpdateInfo}, std::move(txControl));
}

void NSiberia::UpdateSegment(TYdbClient& ydbClient, TUserSetId userSetId, const TSegmentUpdateInfo& segmentUpdateInfo) {
    const auto& path = ydbClient.GetAbsolutePath(GetUserSetDirPath(userSetId));

    const auto result = ExecuteQueryWithRetries(ydbClient.TableClient, [path, segmentUpdateInfo](NYdb::NTable::TSession session, NYT::TPromise<NYdb::NTable::TDataQueryResult> resultPromise) {
        const auto existenceResult = ExecuteSegmentExistsDbRequest(session, path, segmentUpdateInfo.Id, TTxControl::BeginTx(TTxSettings::SerializableRW()));
        if (!existenceResult.IsSuccess()) {
            return existenceResult;
        }

        const auto& segmentExists = NCrypta::NYdbParseUtils::ParseBool(existenceResult.GetResultSet(0), "result");
        if (!segmentExists) {
            resultPromise.Set(NYT::TError("Unknown segment id"));
            return existenceResult;
        }

        auto txControl = TTxControl::Tx(*existenceResult.GetTransaction()).CommitTx();
        const auto result = ExecuteUpdateSegmentDbRequest(session, path, segmentUpdateInfo, std::move(txControl));
        if (result.IsSuccess()) {
            resultPromise.Set(result);
        }

        return result;
    });

    ThrowOnError(result);
}
