#pragma once

#include "helpers.h"

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/segment_update_info.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>

#include <util/string/subst.h>
#include <util/string/vector.h>

namespace NCrypta::NSiberia {
    struct TUpdateSegmentDbRequest {
        struct TRequestParams {
            const TSegmentUpdateInfo& SegmentInfo;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            DECLARE $segmentData AS "Struct<
                id: Uint64,
                title: Optional<Utf8>,
                rule: Optional<Utf8>,
                status: Optional<Utf8>>";

            UPSERT INTO {segments_table}
            SELECT
                id, {fields_to_select}
            FROM AS_TABLE(AsList($segmentData));
        )";

        static TString GetQuery(const TRequestParams& params) {
            TVector<TString> fieldsToSelect;

            const auto& segmentInfo = params.SegmentInfo;
            AddFieldIfDefined(fieldsToSelect, segmentInfo.Title, "title");
            AddFieldIfDefined(fieldsToSelect, segmentInfo.Rule, "rule");
            AddFieldIfDefined(fieldsToSelect, segmentInfo.Status, "status");

            TString query = Query;
            SubstGlobal(query, "{segments_table}", YDB_PATHS.GetSegmentsTable());
            SubstGlobal(query, "{fields_to_select}", JoinVectorIntoString(fieldsToSelect, ", "));
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            return paramsBuilder
                .AddParam("$segmentData")
                .BeginStruct()
                .AddMember("id").Uint64(params.SegmentInfo.Id)
                .AddMember("title").OptionalUtf8(params.SegmentInfo.Title)
                .AddMember("rule").OptionalUtf8(params.SegmentInfo.Rule)
                .AddMember("status").OptionalUtf8(params.SegmentInfo.Status)
                .EndStruct().Build()
                .Build();
        }
    };

    NYdb::NTable::TDataQueryResult ExecuteUpdateSegmentDbRequest(NYdb::NTable::TSession& session, const TString& path, const TSegmentUpdateInfo& segmentUpdateInfo, NYdb::NTable::TTxControl&& txControl);
    void UpdateSegment(TYdbClient& ydbClient, TUserSetId userSetId, const TSegmentUpdateInfo& segmentUpdateInfo);
}
