#include "update_user_set_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteUpdateUserSetDbRequest(TYdbClient& ydbClient, TUserSetId userSetId, const TUserSetUpdateInfo& userSetUpdateInfo) {
    return ExecuteYdbDynamicQuery<TUpdateUserSetDbRequest>(ydbClient, "", {.UserSetId = userSetId, .UserSetUpdateInfo = userSetUpdateInfo});
}

void NSiberia::UpdateUserSet(TYdbClient& ydbClient, TUserSetId userSetId, const TUserSetUpdateInfo& userSetUpdateInfo) {
    const auto result = WaitFor(ExecuteUpdateUserSetDbRequest(ydbClient, userSetId, userSetUpdateInfo)).ValueOrThrow();
    ThrowOnError(result);
}
