#include "user_set_exists_db_request.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/ydb/executer.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/lib/native/ydb/parse_utils.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NYdb::NTable;

NYdb::NTable::TAsyncDataQueryResult NSiberia::ExecuteUserSetExistsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId) {
    return ExecuteYdbDynamicQuery<TUserSetExistsDbRequest>(ydbClient, "", {.UserSetId = userSetId});
}

bool NSiberia::IsUserSetExists(TYdbClient& ydbClient, TUserSetId userSetId) {
    const auto result = WaitFor(ExecuteUserSetExistsDbRequest(ydbClient, userSetId)).ValueOrThrow();
    ThrowOnError(result);
    return NCrypta::NYdbParseUtils::ParseBool(result.GetResultSet(0), "result");
}
