#pragma once

#include <crypta/lib/native/ydb/types.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/types.h>
#include <crypta/siberia/bin/common/ydb/paths/paths.h>

#include <ydb/public/sdk/cpp/client/ydb_driver/driver.h>
#include <ydb/public/sdk/cpp/client/ydb_table/table.h>
#include <yt/yt/core/actions/future.h>

#include <util/string/subst.h>

namespace NCrypta::NSiberia {
    struct TUserSetExistsDbRequest {
        struct TRequestParams {
            TUserSetId UserSetId = 0;
        };

        static constexpr const char* const Query = R"(
            PRAGMA TablePathPrefix("%s");
            DECLARE $userSetId AS UInt64;

            SELECT
                COUNT(*) != 0 AS result
            FROM {user_sets_table}
            WHERE id == $userSetId;
        )";

        static TString GetQuery(const TRequestParams&) {
            TString query = Query;
            SubstGlobal(query, "{user_sets_table}", YDB_PATHS.GetUserSetsTable());
            return query;
        }

        static NYdb::TParams GetParams(NYdb::TParamsBuilder&& paramsBuilder, const TRequestParams& params) {
            paramsBuilder.AddParam("$userSetId").Uint64(params.UserSetId).Build();
            return paramsBuilder.Build();
        }
    };

    NYdb::NTable::TAsyncDataQueryResult ExecuteUserSetExistsDbRequest(TYdbClient& ydbClient, TUserSetId userSetId);
    bool IsUserSetExists(TYdbClient& ydbClient, TUserSetId userSetId);
}
