import ydb


class UserSets(object):
    columns = [
        ydb.Column("id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("title", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("expiration_time", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("type", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("status", ydb.OptionalType(ydb.DataType.Utf8)),
    ]
    primary_key = "id"


class Users(object):
    columns = [
        ydb.Column("id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("creators", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("status", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("value", ydb.OptionalType(ydb.DataType.Double)),
    ]
    primary_key = "id"


class UserAttributes(object):
    columns = [
        ydb.Column("user_id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("attribute_key", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("attribute_value", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("ts", ydb.OptionalType(ydb.DataType.Uint64)),
    ]
    primary_key = ["user_id", "attribute_key", "attribute_value"]


class Segments(object):
    columns = [
        ydb.Column("id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("title", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("rule", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("status", ydb.OptionalType(ydb.DataType.Utf8)),
        ydb.Column("size", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("creation_ts", ydb.OptionalType(ydb.DataType.Uint64)),
    ]
    primary_key = "id"


class UserSegments(object):
    columns = [
        ydb.Column("user_id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("segment_id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("ts", ydb.OptionalType(ydb.DataType.Uint64)),
    ]
    primary_key = ["user_id", "segment_id"]


class SegmentUsers(object):
    columns = [
        ydb.Column("segment_id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("user_id", ydb.OptionalType(ydb.DataType.Uint64)),
    ]
    primary_key = ["segment_id", "user_id"]


class SegmentStats(object):
    columns = [
        ydb.Column("segment_id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("stats", ydb.OptionalType(ydb.DataType.String)),
    ]
    primary_key = "segment_id"


class UserData(object):
    columns = [
        ydb.Column("yuid", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("Strata", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("Attributes", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("Vectors", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("Segments", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("GroupID", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("Identifiers", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("WithoutData", ydb.OptionalType(ydb.DataType.Bool)),
        ydb.Column("CryptaID", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("Affinities", ydb.OptionalType(ydb.DataType.String)),
    ]
    primary_key = "yuid"


class UserSetStats(object):
    columns = [
        ydb.Column("user_set_id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("processed_users_count", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("stats", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("ready", ydb.OptionalType(ydb.DataType.Bool)),
    ]
    primary_key = "user_set_id"


class CryptaIdUserData(object):
    columns = [
        ydb.Column("crypta_id", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("stats", ydb.OptionalType(ydb.DataType.String)),
    ]
    primary_key = "crypta_id"


class Id2CryptaId(object):
    columns = [
        ydb.Column("id_hash", ydb.OptionalType(ydb.DataType.Uint64)),
        ydb.Column("id_type", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("id", ydb.OptionalType(ydb.DataType.String)),
        ydb.Column("crypta_id", ydb.OptionalType(ydb.DataType.Uint64)),
    ]
    primary_key = ["id_hash", "id_type", "id"]
