#include "matcher.h"

#include <crypta/siberia/bin/common/yt_describer/proto/grouped_id.pb.h>
#include <crypta/siberia/bin/common/yt_describer/proto/id_to_crypta_id.pb.h>

#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NYtDescriber;

void TMatcher::Do(TReader *reader, TWriter *writer) {
    TMaybe<ui64> cryptaId;
    THashSet<TString> groupIds;

    for (; reader->IsValid(); reader->Next()) {
        if (reader->GetTableIndex() == 0) {
            const auto& row = reader->GetRow<TGroupedId>();
            groupIds.insert(row.GetGroupID());

            if (!cryptaId.Defined() && row.GetIdType() == "crypta_id") {
                cryptaId = FromString<ui64>(row.GetIdValue());
            }
        } else {
            const auto& row = reader->GetRow<TIdToCryptaId>();
            cryptaId = row.GetCryptaId();
        }
    }

    if (cryptaId.Defined()) {
        for (const auto& groupId : groupIds) {
            TGroupedCryptaId row;
            row.SetGroupID(groupId);
            row.SetCryptaId(cryptaId.GetRef());
            writer->AddRow(row);
        }
    }
}
