#include "sampler.h"

#include <util/generic/maybe.h>
#include <util/generic/queue.h>
#include <util/random/random.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NYtDescriber;

namespace {
    struct TQueueItem {
        ui32 Random = 0;
        TGroupedId GroupedId;

        bool operator<(const TQueueItem& other) const {
            return Random < other.Random;
        }
    };
}

void TSampler::Do(TReader *reader, TWriter *writer) {
    TPriorityQueue<TQueueItem> pq;

    for (; reader->IsValid(); reader->Next()) {
        pq.push({.Random=RandomNumber<ui32>(), .GroupedId=reader->GetRow()});

        if (pq.size() > State->GetMaxSampleSize()) {
            pq.pop();
        }
    }

    while (!pq.empty()) {
        writer->AddRow(pq.top().GroupedId);
        pq.pop();
    }
}
