#include "stats_getter.h"

#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NYtDescriber;

void TStatsGetter::Do(TReader *reader, TWriter *writer) {
    /* Т.к. редьюс идёт по крипта айди, то сет позволит избавится от дубликатов крипта айди для каждого групп айди */
    THashSet<TString> groupIds;
    TMaybe<TCryptaIdStats> cryptaIdStats;

    for (; reader->IsValid(); reader->Next()) {
        if (reader->GetTableIndex() == 0) {
            const auto& row = reader->GetRow<TGroupedCryptaId>();
            groupIds.insert(row.GetGroupID());
        } else {
            cryptaIdStats = reader->GetRow<TCryptaIdStats>();
        }
    }

    if (cryptaIdStats.Defined()) {
        for (const auto& groupId : groupIds) {
            TGroupSerializedStats row;
            row.SetGroupID(groupId);
            row.SetStats(cryptaIdStats->GetStats());
            writer->AddRow(row);
        }
    }
}
