#include "stats_merger.h"

#include <crypta/lab/lib/native/user_data_stats_aggregator.h>
#include <crypta/lib/native/proto_serializer/proto_serializer.h>

#include <library/cpp/streams/zstd/zstd.h>

#include <util/generic/hash_set.h>
#include <util/generic/maybe.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia::NYtDescriber;

void TStatsMerger::Do(TReader *reader, TWriter *writer) {
    NLab::TUserDataStatsAggregator<> statsAggregator;

    TMaybe<TString> groupId;

    for (; reader->IsValid(); reader->Next()) {
        const auto& row = reader->GetRow();
        groupId = row.GetGroupID();
        statsAggregator.UpdateWith(row.GetStats());
    }

    if (groupId.Defined()) {
        TGroupStats row;
        row.SetGroupID(groupId.GetRef());

        auto userDataStats = row.MutableStats();
        statsAggregator.MergeInto(*userDataStats);

        writer->AddRow(row);
    }
}
