#include "convert_to_user_data_stats_job.h"

#include <crypta/lib/native/yt/utils/helpers.h>
#include <crypta/siberia/bin/common/convert_to_user_data_stats/cpp/register.h>
#include <crypta/siberia/bin/common/yt_schemas/cpp/schemas.h>

#include <mapreduce/yt/common/config.h>
#include <mapreduce/yt/interface/common.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;
using namespace NCrypta::NSiberia::NCryptaIdUserData;
using namespace NCrypta::NSiberia::NConvertToUserDataStats;

int NConvertToUserDataStats::ConvertToUserDataStatsJob(TConvertToUserDataStatsJobConfig config, NLog::TLogPtr) {
    auto client = NYT::CreateClient(config.GetYt().GetProxy());
    NYT::TConfig::Get()->Pool = config.GetYt().GetPool();

    const auto& dstTable = config.GetOutputTable();
    const auto dstTableWithSchema = NYT::TRichYPath(dstTable).Schema(GetCryptaIdUserDataStatsSchema()).OptimizeFor(NYT::OF_SCAN_ATTR);

    auto tx = client->StartTransaction();

    tx->Remove(dstTable);

    tx->Map(
        NYT::TMapOperationSpec()
            .AddInput<NLab::TUserData>(config.GetInputTable())
            .AddOutput<NYT::TNode>(dstTable),
        new TConvertToUserDataStatsMapper()
    );

    tx->Sort(dstTable, dstTableWithSchema, {NFields::CRYPTA_ID});

    tx->Commit();

    return 0;
}
