#include "describing_sender.h"

#include <crypta/lib/native/time/shifted_clock.h>
#include <crypta/siberia/bin/common/describing/proto/describe_cmd.pb.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TDescribingSender::TDescribingSender(NCrypta::NPQ::TProducer& producer)
    : TCommandSender(producer)
{}

void TDescribingSender::DescribeUserSet(TUserSetId userSetId) {
    TDescribeCmd describeCmd;
    describeCmd.MutableDescribeUserSetCmd()->SetUserSetId(userSetId);
    describeCmd.SetTimestamp(TShiftedClock::Now().Seconds());
    Y_ENSURE(TryEnqueue(describeCmd), "Error while sending describe command");
}

void TDescribingSender::DescribeIds(TUserSetId userSetId, const TIds& ids, const TDescribingExperiment& experiment) {
    TDescribeCmd describeCmd;
    auto* describeIdsCmd = describeCmd.MutableDescribeIdsCmd();
    describeIdsCmd->SetUserSetId(userSetId);
    describeIdsCmd->MutableIds()->CopyFrom(ids.GetIds());
    describeIdsCmd->MutableExperiment()->CopyFrom(experiment);
    describeCmd.SetTimestamp(TShiftedClock::Now().Seconds());

    Y_ENSURE(TryEnqueue(describeCmd), "Error while sending describe command");
}
