#include "mutation_sender.h"

#include <crypta/siberia/bin/common/mutations/proto/mutation.pb.h>
#include <crypta/siberia/bin/common/mutations/proto/remove_segment_data_command.pb.h>
#include <crypta/siberia/bin/common/mutations/proto/remove_user_set_data_command.pb.h>

#include <library/cpp/protobuf/json/proto2json.h>

using namespace NCrypta::NSiberia;

TMutationSender::TMutationSender(NCrypta::NPQ::TProducer& producer)
    : TCommandSender(producer)
{
}

void TMutationSender::RemoveSegmentData(TUserSetId userSetId, const TSegmentId& segmentId) {
    TMutation mutation;
    auto* command = mutation.MutableRemoveSegmentDataCommand();
    command->SetUserSetId(userSetId);
    command->SetSegmentId(segmentId);

    TryEnqueue(mutation);
}

void TMutationSender::RemoveUserSetData(TUserSetId userSetId) {
    TMutation mutation;
    auto* command = mutation.MutableRemoveUserSetDataCommand();
    command->SetUserSetId(userSetId);

    TryEnqueue(mutation);
}
