#include "segmentation_sender.h"

#include <crypta/siberia/bin/common/segmentation/proto/message.pb.h>
#include <crypta/siberia/bin/common/segmentation/proto/segmentate_command.pb.h>

#include <library/cpp/protobuf/json/proto2json.h>

using namespace NCrypta::NSiberia;

TSegmentationSender::TSegmentationSender(NCrypta::NPQ::TProducer& producer)
    : TCommandSender(producer)
{
}

void TSegmentationSender::Segmentate(TUserSetId userSetId, const TSegmentId& segmentId) {
    TMessage message;
    auto* command = message.MutableSegmentateCommand();
    command->SetUserSetId(userSetId);
    command->SetSegmentId(segmentId);

    Y_ENSURE(TryEnqueue(message), "Error while sending segmentation command");
}
