#include "add_user_set_request_processor.h"

#include <crypta/siberia/bin/common/data/helpers/user_set_helpers.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/add_user_set_db_request.h>
#include <crypta/siberia/bin/core/proto/add_user_set_response.pb.h>

#include <library/cpp/protobuf/json/proto2json.h>

#include <util/generic/algorithm.h>

using namespace NCrypta::NSiberia;

TAddUserSetProcessor::TAddUserSetProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings, ui64 minTtlSeconds)
    : TBase(NLog::GetLog("add_user_set"), TaggedSingleton<TStats, decltype(*this)>("processors.add_user_set", statsSettings), ydbClient)
    , MinTtl(TDuration::Seconds(minTtlSeconds))
{}

void TAddUserSetProcessor::Process(NHttp::TRequestReply& reply, const TAddUserSetRequest& request) {
    const auto& ttl = Max(MinTtl, request.Ttl);
    const auto userSetId = AddUserSet(YdbClient, request.Title, ttl, NUserSetHelpers::USER_SET_TYPE.GetMaterialized(), NUserSetHelpers::USER_SET_STATUS.GetNotReady());
    TAddUserSetResponse response;
    response.SetUserSetId(ToString(userSetId));
    SendResponse(reply, HTTP_OK, NProtobufJson::Proto2Json(response));
}
