#pragma once

#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/logic/add_user_set/request/add_user_set_request_parser.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/ydb_request_processor.h>

namespace NCrypta::NSiberia {
    class TAddUserSetProcessor : public TYdbRequestProcessor<TAddUserSetRequest, TAddUserSetRequestParser> {
        using TBase = TYdbRequestProcessor<TAddUserSetRequest, TAddUserSetRequestParser>;

    public:
        TAddUserSetProcessor(TYdbClient& ydbClient, const TStats::TSettings& statsSettings, ui64 minTtlSeconds);

    private:
        void Process(NHttp::TRequestReply& reply, const TAddUserSetRequest& request) override final;

        TDuration MinTtl;
    };
}
