#include "add_user_set_request_parser.h"

#include <crypta/lib/native/cgiparam/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>

#include <util/string/cast.h>
#include <util/datetime/base.h>

using namespace NCrypta;
using namespace NCrypta::NSiberia;

TAddUserSetRequest TAddUserSetRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/user_sets/add", "Not /user_sets/add request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TAddUserSetRequest TAddUserSetRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    return {
        .Title = NCgiParam::GetNonEmptyString(cgi, "title"),
        .Ttl = TDuration::Seconds(NCgiParam::Get<ui64>(cgi, "ttl"))
    };
}
