#include "add_users_request_parser.h"

#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/protobuf/json/json2proto.h>

#include <util/string/cast.h>

using namespace NCrypta::NSiberia;

TInsertUsersRequest TInsertUsersRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/users/add", "Not /users/add request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TInsertUsersRequest TInsertUsersRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    TInsertUsersRequest request {
        .UserSetId = NCgiParamUtils::GetUserSetId(cgi),
        .AddUsersRequest = NProtobufJson::Json2Proto<TAddUsersRequest>(body, NProtobufJson::TJson2ProtoConfig().SetMapAsObject(true))
    };

    Y_ENSURE(request.AddUsersRequest.UsersSize() != 0, "No users found");

    return request;
}
