#include "cgiparam.h"

#include <crypta/lib/native/cgiparam/cgiparam.h>

using namespace NCrypta::NSiberia;

TUserSetId NCgiParamUtils::GetUserSetId(const TCgiParameters& cgi) {
    return NCrypta::NCgiParam::Get<TUserSetId>(cgi, "user_set_id");
}

TSegmentId NCgiParamUtils::GetSegmentId(const TCgiParameters& cgi) {
    return NCrypta::NCgiParam::Get<TSegmentId>(cgi, "segment_id");
}

TMaybe<ui64> NCgiParamUtils::GetLimit(const TCgiParameters& cgi) {
    static const TString field = "limit";
    const auto& limit = NCrypta::NCgiParam::GetOptional<ui64>(cgi, field);
    Y_ENSURE(!limit.Defined() || *limit != 0, "Param '" + field + "' is equal to 0");
    return limit;
}
