#pragma once

#include "ydb_request_processor.h"

#include <crypta/lib/native/http/format.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/common/data/helpers/user_set_helpers.h>
#include <crypta/siberia/bin/common/ydb/requests/get_user_set_db_request.h>

namespace NCrypta::NSiberia {
    struct TDefaultPolicy {
        static bool Check(const TUserSet&) {
            return true;
        }
    };

    struct TMustBeNotReadyPolicy {
        static bool Check(const TUserSet& userSet) {
            return NUserSetHelpers::IsMaterialized(userSet) && !NUserSetHelpers::IsReady(userSet);
        }
    };

    struct TMustHaveMetaDataPolicy {
        static bool Check(const TUserSet& userSet) {
            return NUserSetHelpers::IsReady(userSet) || NUserSetHelpers::IsMetaDataOnly(userSet);
        }
    };

    struct TMustBeMaterializedReadyPolicy {
        static bool Check(const TUserSet& userSet) {
            return NUserSetHelpers::IsMaterialized(userSet) && NUserSetHelpers::IsReady(userSet);
        }
    };

    template<typename TRequest, typename TRequestParser, typename TPolicy = TDefaultPolicy>
    class TUserSetRequestProcessor : public TYdbRequestProcessor<TRequest, TRequestParser> {
        using TBase = TYdbRequestProcessor<TRequest, TRequestParser>;

    public:
        TUserSetRequestProcessor(NLog::TLogPtr log, TStats& stats, TYdbClient& ydbClient)
            : TBase(log, stats, ydbClient)
        {}

        void Process(NHttp::TRequestReply& reply, const TRequest& request) override {
            const auto& userSet = GetUserSet(this->YdbClient, request.UserSetId);
            if (userSet.Defined()) {
                if (TPolicy::Check(*userSet)) {
                    DoProcess(reply, request);
                } else {
                    TBase::SendResponse(reply, HTTP_METHOD_NOT_ALLOWED, NHttp::GetSimpleResponse("Method not allowed for this user set"));
                }
            } else {
                TBase::SendResponse(reply, HTTP_NOT_FOUND, NHttp::GetSimpleResponse("User set not found"));
            }
        }

    protected:
        virtual void DoProcess(NHttp::TRequestReply& reply, const TRequest& request) = 0;
    };
}

