#pragma once

#include <ydb/public/sdk/cpp/client/ydb_table/table.h>

#include <crypta/lab/lib/native/stats.h>
#include <crypta/siberia/bin/core/lib/command_senders/describing_sender.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/describe_ids/request/describe_ids_request_parser.h>

namespace NCrypta::NSiberia {
    class TDescribeIdsProcessor : public TYdbRequestProcessor<TDescribeIdsRequest, TDescribeIdsRequestParser> {
        using TBase = TYdbRequestProcessor<TDescribeIdsRequest, TDescribeIdsRequestParser>;

    public:
        TDescribeIdsProcessor(
            TYdbClient& ydbClient,
            TDescribingSender& describingSender,
            TDescribingSender& slowDescribingSender,
            const TStats::TSettings& statsSettings,
            size_t maxIdsCount,
            ui64 defaultTtlSeconds
        );

    private:
        void Process(NHttp::TRequestReply& reply, const TDescribeIdsRequest& request) override final;

        TDescribingSender& DescribingSender;
        TDescribingSender& SlowDescribingSender;
        size_t MaxIdsCount = 0;
        TDuration DefaultTtl;
    };
}

