#include "describe_ids_request_parser.h"

#include <crypta/lib/native/cgiparam/cgiparam.h>
#include <crypta/lib/native/identifiers/lib/id_types/all.h>
#include <crypta/siberia/bin/common/describing/mode/cpp/describing_mode.h>
#include <crypta/siberia/bin/common/describing/experiment/proto/describing_experiment.pb.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <library/cpp/protobuf/json/json2proto.h>
#include <market/library/maybe_monad/maybe_monad.h>

#include <util/string/builder.h>
#include <util/string/cast.h>
#include <util/string/split.h>

using namespace NCrypta;
using namespace NCrypta::NCgiParam;
using namespace NCrypta::NSiberia;

namespace {
    TIds ParseIds(const TStringBuf& body) {
        const auto& ids = NProtobufJson::Json2Proto<TIds>(body, {.AllowUnknownFields=false});
        Y_ENSURE(ids.IdsSize() != 0, "No ids found");
        return ids;
    }
}

TDescribeIdsRequest TDescribeIdsRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/user_sets/describe_ids", "Not /user_sets/describe_ids request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TDescribeIdsRequest TDescribeIdsRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    const auto mode = NCgiParam::GetOptional<TString>(cgi, "mode").GetOrElse(DESCRIBING_MODE.GetFast());
    Y_ENSURE(IsValidDescribingMode(mode), "Invalid mode");

    return {
        .Ids = ParseIds(body),
        .Mode = std::move(mode),
        .Experiment = Map(NCgiParam::GetOptional<TString>(cgi, "experiment"), [](const TString& s) { return NProtobufJson::Json2Proto<TDescribingExperiment>(s); }).GetOrElse(TDescribingExperiment()),
        .Ttl = Map(NCgiParam::GetOptional<ui64>(cgi, "ttl"), [](const ui64 sec) { return TDuration::Seconds(sec); })
    };
}
