#include "describe_segment_request_processor.h"

#include <crypta/lib/native/concurrency/wait_for.h>
#include <crypta/lib/native/http/format.h>
#include <crypta/lib/native/ydb/helpers.h>
#include <crypta/lib/proto/user_data/user_data.pb.h>
#include <crypta/lib/proto/user_data/user_data_stats.pb.h>
#include <crypta/siberia/bin/common/describing/paths/paths.h>
#include <crypta/siberia/bin/common/ydb/requests/segment_exists_db_request.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/describe_segment_db_request.h>
#include <crypta/siberia/bin/core/lib/ydb/requests/save_segment_stats_db_request.h>

using namespace NCrypta::NSiberia;
using namespace NYdb;
using namespace NTable;

TDescribeSegmentProcessor::TDescribeSegmentProcessor(TYdbClient& ydbClient, TDescribingSender& describingSender, const TStats::TSettings& statsSettings)
    : TBase(NLog::GetLog("describe_segment"), TaggedSingleton<TStats, decltype(*this)>("processors.describe_segment", statsSettings), ydbClient)
    , DescribingSender(describingSender)
{}

void TDescribeSegmentProcessor::DoProcess(NHttp::TRequestReply& reply, const TDescribeSegmentRequest& /*request*/) {
    // TODO(dkuksa, kolontaev): Implement command sending
    Y_UNUSED(DescribingSender);
    SendResponse(reply, HTTP_NOT_IMPLEMENTED, NHttp::GetSimpleResponse("Not implemented"));
}
