#pragma once

#include <crypta/lab/lib/native/stats.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/command_senders/describing_sender.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/describe_segment/request/describe_segment_request_parser.h>

namespace NCrypta::NSiberia {
    class TDescribeSegmentProcessor : public TUserSetRequestProcessor<TDescribeSegmentRequest, TDescribeSegmentRequestParser, TMustBeMaterializedReadyPolicy> {
        using TBase = TUserSetRequestProcessor<TDescribeSegmentRequest, TDescribeSegmentRequestParser, TMustBeMaterializedReadyPolicy>;

    public:
        TDescribeSegmentProcessor(TYdbClient& ydbClient, TDescribingSender& describingSender, const TStats::TSettings& statsSettings);

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TDescribeSegmentRequest& request) override final;

        TDescribingSender& DescribingSender;
    };
}

