#include "describe_segment_request_parser.h"

#include <crypta/siberia/bin/core/lib/logic/common/helpers/cgiparam.h>

#include <library/cpp/http/misc/parsed_request.h>
#include <util/string/cast.h>

using namespace NCrypta::NSiberia;

TDescribeSegmentRequest TDescribeSegmentRequestParser::Parse(const TString& query, const TStringBuf& body) {
    TParsedHttpLocation httpLocation(query);

    Y_ENSURE(httpLocation.Path == "/segments/describe", "Not /segments/describe request");

    return Parse(TCgiParameters(httpLocation.Cgi), body);
}

TDescribeSegmentRequest TDescribeSegmentRequestParser::Parse(const TCgiParameters& cgi, const TStringBuf& body) {
    Y_UNUSED(body);

    return {
        .UserSetId = NCgiParamUtils::GetUserSetId(cgi),
        .SegmentId = NCgiParamUtils::GetSegmentId(cgi)
    };
}
