#pragma once

#include <crypta/lab/lib/native/stats.h>
#include <crypta/lib/native/ydb/ydb_client.h>
#include <crypta/siberia/bin/core/lib/command_senders/describing_sender.h>
#include <crypta/siberia/bin/core/lib/logic/common/request_processor/user_set_request_processor.h>
#include <crypta/siberia/bin/core/lib/logic/describe_user_set/request/describe_user_set_request_parser.h>

namespace NCrypta::NSiberia {
    class TDescribeUserSetProcessor : public TUserSetRequestProcessor<TDescribeUserSetRequest, TDescribeUserSetRequestParser, TMustBeMaterializedReadyPolicy> {
        using TBase = TUserSetRequestProcessor<TDescribeUserSetRequest, TDescribeUserSetRequestParser, TMustBeMaterializedReadyPolicy>;

    public:
        TDescribeUserSetProcessor(TYdbClient& ydbClient, TDescribingSender& describingSender, const TStats::TSettings& statsSettings);

    private:
        void DoProcess(NHttp::TRequestReply& reply, const TDescribeUserSetRequest& request) override final;
        bool TryToClearStats(TUserSetId userSetId);

        TDescribingSender& DescribingSender;
    };
}

